﻿using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Linq;
using Sf.Blazor.Dashboard.Example.Factories;

namespace Sf.Blazor.Dashboard.Example.ViewModels
{
    public class IndexViewModel : NotifyPropertyChangedBase
    {
        private static IndexViewModel _current;
        private ObservableCollection<DashLayoutViewModel> _currentLayouts;
        private bool _isInEditMode;
        private string _lastSelectedProfileName;

        private ObservableCollection<ProfileViewModel> _profiles = new ObservableCollection<ProfileViewModel>();
        private ProfileViewModel _selectedProfile;

        public static IndexViewModel Current => _current ??= IndexViewModelFactory.Default();

        public ObservableCollection<DashLayoutViewModel> CurrentLayouts
        {
            get => _currentLayouts;
            set => Set(ref _currentLayouts, value);
        }

        public bool IsInEditMode
        {
            get => _isInEditMode;
            set => Set(ref _isInEditMode, value);
        }

        public ObservableCollection<ProfileViewModel> Profiles
        {
            get => _profiles;
            set => Set(ref _profiles, value);
        }

        public ProfileViewModel SelectedProfile
        {
            get => _selectedProfile;
            set
            {
                Set(ref _selectedProfile, value);

                if (value != null)
                {
                    _lastSelectedProfileName = value.Name;
                }
            }
        }

        public void Refresh()
        {
            Reset();

            Profiles = new ObservableCollection<ProfileViewModel>(ProfileViewModelFactory.Default);
            SelectedProfile = _lastSelectedProfileName != null
                ? Profiles.Single(o => o.Name == _lastSelectedProfileName)
                : Profiles.First();

            CurrentLayouts = new ObservableCollection<DashLayoutViewModel>(
                DashLayoutViewModelFactory.CreateListForProfile(SelectedProfile.Name));
        }

        public void ToggleEditMode()
        {
            IsInEditMode = !IsInEditMode;
        }

        private void Reset()
        {
            SelectedProfile = null;
            CurrentLayouts.Clear();
            Profiles.Clear();
        }
    }
}